/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.dba;

import com.ibm.hwmca.base.rsf.connserv.ZDbaCommPath;
import com.ibm.hwmca.base.rsf.dba.DbaErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connserv.PathRequestInfo;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.util.Date;

public class DbaTasklet
extends Tasklet
implements DbaErrorIds {
    private static final String TRACE_MASKT = "XDBASRVT";
    private static final String TRACE_MASKF = "XDBASRVF";
    private static final String TRACE_MASKD = "XDBASRVD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-93, "DbaServer");
    private static final String LAUNCH_SCRIPT = "xlaunch";
    private static final String EMULATOR_NAME = "x3270";
    private static final String EMULATOR_PARM = "-once";
    private static final String EMULATOR_PARM_2A = "-display";
    private String ipAddress;
    private ZDbaCommPath path = null;

    public DbaTasklet() {
        Trace.trace(TRACE_MASKT, "<> DbaTasklet()");
    }

    public void init(Object o) {
        Trace.trace(TRACE_MASKT, "<> DbaTasklet.init()");
    }

    public void service(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> DbaTasklet.service()");
        String s = (String)request.getData("state");
        if (s != null) {
            if (s.equals("start")) {
                Trace.trace(TRACE_MASKD, "  got a start ");
                if (this.askForPath()) {
                    try {
                        Date date = new Date();
                        InetAddress localInet = UserContext.getCurrentUserContext().getAddress();
                        String localUser = UserContext.getCurrentUserContext().getUserid();
                        String[] p = new String[]{LAUNCH_SCRIPT, EMULATOR_NAME, EMULATOR_PARM, EMULATOR_PARM_2A, localInet.getHostAddress() + ":0", this.ipAddress};
                        Trace.trace(TRACE_MASKF, date.toString() + " user [" + localUser + "] starting " + p[0] + " " + p[1] + " " + p[2] + " " + p[3] + " for " + p[4]);
                        NativeProcessParameters parms = new NativeProcessParameters(p);
                        NativeProcess process = NativeProcess.exec(parms);
                        this.logInfo(1);
                        process.waitFor();
                        this.releasePath();
                        Trace.trace(TRACE_MASKF, date.toString() + " user [" + localUser + "] terminating " + p[0] + " for " + p[4]);
                        this.logInfo(2);
                    }
                    catch (Throwable t) {
                        Trace.trace(TRACE_MASKD, "caught throwable " + t);
                    }
                    response.noAction();
                } else {
                    Trace.trace(TRACE_MASKF, "no path available, terminating ");
                    response.terminate();
                }
            } else if (s.equals("stop")) {
                Trace.trace(TRACE_MASKD, " got a stop, terminate link ");
                response.terminate();
            } else if (s.equals("error")) {
                Trace.trace(TRACE_MASKD, " got an error , report & terminate link ");
                this.releasePath();
                response.terminate();
            } else {
                response.noAction();
            }
        } else {
            Trace.trace(TRACE_MASKF, "null parm; noAction ");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- DbaTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> DbaTasklet.logException(" + throwable + ")");
        HException hexc = new HException(throwable);
        new FrameworkLog(logInfo, 258, hexc).log();
        Trace.trace(TRACE_MASKT, "<- DbaTasklet.logException()");
    }

    public void logInfo(int flag) {
        Trace.trace(TRACE_MASKT, "-> DbaTasklet.logInfo()");
        short id = 0;
        id = flag == 1 ? (short)256 : 257;
        FrameworkLog log = new FrameworkLog(logInfo, id);
        log.log(FrameworkLogAttributes.INFO_LOG);
        Trace.trace(TRACE_MASKT, "<- DbaTasklet.logInfo()");
    }

    private boolean askForPath() {
        boolean pathAvailable = false;
        Trace.trace(TRACE_MASKF, "-> DbaTasklet.askForPath");
        try {
            PathRequestInfo info = new PathRequestInfo("local", new Date(), new LocalizableText("DBA00003Description"));
            this.path = new ZDbaCommPath(2, info);
            this.path.waitForAvailability();
            this.path.open();
            this.ipAddress = this.path.getConnectionInfo().getIpAddress();
            pathAvailable = true;
        }
        catch (Throwable e) {
            Trace.trace(TRACE_MASKF, "<- DbaTasklet.askForPath- exception " + e);
        }
        Trace.trace(TRACE_MASKF, "<- DbaTasklet.askForPath(" + pathAvailable + ")");
        return pathAvailable;
    }

    private void releasePath() {
        Trace.trace(TRACE_MASKF, "-> DbaTasklet.releasePath");
        this.ipAddress = null;
        try {
            if (this.path != null) {
                this.path.close();
                this.path = null;
            } else {
                Trace.trace(TRACE_MASKF, "don't think there was a path to release ");
            }
        }
        catch (Throwable e) {
            Trace.trace(TRACE_MASKF, "<- DbaTasklet.releasePath- exception " + e);
            this.logException(e);
        }
        Trace.trace(TRACE_MASKF, "<- DbaTasklet.releasePath");
    }
}

